<?php
session_start();
include_once '../config/config.php';
$query = "SELECT * FROM yourlearning ORDER BY id DESC";
$result = mysqli_query($GLOBALS['conn'], $query);
if (isset($_SESSION['message'])) {
  echo "<script>alert('" . $_SESSION['message'] . "');</script>";
  unset($_SESSION['message']);
}
if (isset($_SESSION['error'])) {
  echo "<script>alert('" . $_SESSION['error'] . "');</script>";
  unset($_SESSION['error']);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title><?php echo getcompany(); ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="icon" href="../images/favicon.png" type="image/png">
  <!-- Bootstrap -->
  <link href="../vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome -->
  <link href="../vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet">
  <!-- iCheck -->
  <link href="../vendors/iCheck/skins/flat/red.css" rel="stylesheet">
  <!-- Custom CSS -->
  <link href="css/custom.min.css" rel="stylesheet">
  <link href="css/custom.css" rel="stylesheet">
  <script src="js/validate.js"></script>
  <script src="js/validate1.js"></script>
</head>
<body class="nav-md">
  <div class="container body">
    <div class="main_container">
      <div class="col-md-3 left_col" style="background-color:#990;">
        <div class="left_col scroll-view">
          <?php include "navbar.php"; ?>
          <br />
          <?php include "sidebar.php"; ?>
        </div>
      </div>
      <?php include "topbar.php"; ?>
      <!-- page content -->
      <div class="right_col" role="main">
        <?php include "topData.php"; ?>
        <div class="panel panel-default">
          <div class="panel-heading">
            <h3 class="panel-title">Upload Video</h3>
          </div>
          <div class="panel-body">
            <form action="../controller/ctrluploadVideo.php" method="post" enctype="multipart/form-data">
              <div class="form-group">
                <label for="video_name">Video Name:</label>
                <input type="text" name="video_name" class="form-control" id="video_name" required>
              </div>
              <div class="form-group">
                <label for="video_file">Video File:</label>
                <input type="file" name="video_file" class="form-control" id="video_file" accept="video/*" required>
              </div>
              <!-- New dropdown for Category -->
              <div class="form-group">
                <label for="video_category">Video Category:</label>
                <select name="video_category" id="video_category" class="form-control" required>
                  <option value="">-- Select Category --</option>
                  <option value="SWP-Beginner-2500">SWP-Beginner-2500</option>
                  <option value="SWP-Advance-2500">SWP-Advance-2500</option>
                  <option value="SWP-Option Expert-2500">SWP-Option Expert-2500</option>
                </select>
              </div>
              <div class="form-group">
                <label for="video_description">Video Description:</label>
                <textarea name="video_description" class="form-control" id="video_description" rows="4" required></textarea>
              </div>
              <button type="submit" class="btn btn-primary">Upload Video</button>
            </form>
          </div>
        </div>
		<div class="panel panel-default">
          <div class="panel-heading">
            <h3 class="panel-title">Add Video</h3>
          </div>
          <div class="panel-body">
            <form action="../controller/ctrlAddVideo.php" method="post" enctype="multipart/form-data">
              <div class="form-group">
                <label for="video_name">Video Name:</label>
                <input type="text" name="video_name" class="form-control" id="video_name" required>
              </div>
              <div class="form-group">
                <label for="video_file">Video File Name (Case Sensetive):</label>
                <input type="text" name="video_file_name" class="form-control" id="video_file_name" required>
              </div>
              <!-- New dropdown for Category -->
              <div class="form-group">
                <label for="video_category">Video Category:</label>
                <select name="video_category" id="video_category" class="form-control" required>
                  <option value="">-- Select Category --</option>
                  <option value="SWP-Beginner-2500">SWP-Beginner-2500</option>
                  <option value="SWP-Advance-2500">SWP-Advance-2500</option>
                  <option value="SWP-Option Expert-2500">SWP-Option Expert-2500</option>
                </select>
              </div>
              <div class="form-group">
                <label for="video_description">Video Description:</label>
                <textarea name="video_description" class="form-control" id="video_description" rows="4" required></textarea>
              </div>
              <button type="submit" class="btn btn-primary">Upload Video</button>
            </form>
          </div>
        </div>
        <!-- /page content -->
        <div class="panel panel-default">
          <div class="panel-heading">
            <h3 class="panel-title">Uploaded Videos</h3>
          </div>
          <div class="panel-body">
            <div class="table-responsive" style="background-color: #f7f7f7; padding: 15px; border-radius: 8px;">
              <table class="table table-bordered table-striped">
                <table class="table table-bordered">
                  <thead>
                    <tr>
                      <th>Video Name</th>
                      <th>Video</th>
                      <th>Description</th>
                      <th>Category</th>
                      <th>Action</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php while ($row = mysqli_fetch_assoc($result)) { ?>
                      <tr>
                        <td><?php echo htmlspecialchars($row['vname']); ?></td>
                        <td>
                          <video width="200" controls controlsList="nodownload">
                            <source src="../upload/yourlearning/<?php echo $row['vfilepath']; ?>" type="video/mp4">
                            Your browser does not support the video tag.
                          </video>
                        </td>
                        <td><?php echo nl2br(htmlspecialchars($row['vdescription'])); ?></td>
                        <td><?php echo nl2br(htmlspecialchars($row['category'])); ?></td>
                        <td>
                          <form action="../controller/deleteVideo.php" method="post" onsubmit="return confirm('Are you sure you want to delete this video?');">
                            <input type="hidden" name="video_id" value="<?php echo $row['id']; ?>">
                            <input type="hidden" name="vfilepath" value="<?php echo $row['vfilepath']; ?>">
                            <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                          </form>
                        </td>
                      </tr>
                    <?php } ?>
                  </tbody>
                </table>
            </div>
          </div>
        </div>
      </div><?php include "footer.php"; ?>
      <!-- Core JS -->
      <script src="../vendors/jquery/dist/jquery.min.js"></script>
      <script src="../vendors/bootstrap/dist/js/bootstrap.min.js"></script>
      <script src="../vendors/fastclick/lib/fastclick.js"></script>
      <script src="../vendors/nprogress/nprogress.js"></script>
      <script src="../vendors/iCheck/icheck.min.js"></script>
      <!-- Custom Theme Scripts -->
      <script src="js/custom.min.js"></script>
</body>
</html>