<?php

session_start();

include_once '../config/config.php';



if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $videoName = $_POST['video_name'];

    $videoDescription = $_POST['video_description'];

    $video_category = $_POST['video_category'];

    $videoFile = $_FILES['video_file'];



    if (isset($videoFile) && $videoFile['error'] === UPLOAD_ERR_OK) {

        $uploadDir = '../upload/yourlearning/';



        // Ensure directory exists

        if (!is_dir($uploadDir)) {

            mkdir($uploadDir, 0755, true);

        }



        // Get original file name and extension

        $originalName = pathinfo($videoFile['name'], PATHINFO_FILENAME);

        $extension = strtolower(pathinfo($videoFile['name'], PATHINFO_EXTENSION));



        // Sanitize file name

        $safeName = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $originalName);

        $uniqueName = $safeName . '_' . time() . '.' . $extension;



        $uploadPath = $uploadDir . $uniqueName;



        // Optional: Validate MIME type

        $allowedTypes = ['video/mp4', 'video/webm', 'video/ogg'];

        if (!in_array($videoFile['type'], $allowedTypes)) {

            $_SESSION['error'] = "Invalid video format. Allowed: MP4, WebM, OGG.";

            header("Location: ../admin/adyourlearning.php");

            exit;

        }



        if (move_uploaded_file($videoFile['tmp_name'], $uploadPath)) {

            // Save only the filename (not full path) in DB

            $safeVideoName = mysqli_real_escape_string($conn, $videoName);

            $safeDescription = mysqli_real_escape_string($conn, $videoDescription);

            $safeCategory = mysqli_real_escape_string($conn, $video_category);

            $safeFilePath = mysqli_real_escape_string($conn, $uniqueName);



            $query = "INSERT INTO yourlearning (vname, category, vdescription, vfilepath) 

                      VALUES ('$safeVideoName', '$safeCategory', '$safeDescription', '$safeFilePath')";



            if (mysqli_query($conn, $query)) {

                $_SESSION['message'] = "Video uploaded successfully.";

            } else {

                $_SESSION['error'] = "Database error: " . mysqli_error($conn);

            }

        } else {

            $_SESSION['error'] = "Failed to move uploaded file.";

        }

    } else {

        $_SESSION['error'] = "Upload error or no file selected.";

    }



    header("Location: ../admin/adyourlearning.php");

    exit;

}



mysqli_close($conn);

?>

