<?php
session_start();
include_once '../config/config.php';

$query = "SELECT * FROM yourlearning";
$result = mysqli_query($conn, $query);
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php echo getcompany(); ?></title>
  <link href="../vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="../vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet">
  <link href="css/jquery-ui.css" rel="stylesheet" />
  <script src="../vendors/jquery/dist/jquery.min.js"></script>
  <link href="../vendor/datatables/css/jquery.dataTables.min.css" rel="stylesheet">
  <link href="css/custom.min.css" rel="stylesheet">
  <link href="css/custom.css" rel="stylesheet">

  <style>
    .video-list {
      display: flex;
      flex-direction: column;
      align-items: center;
      /* Center horizontal alignment */
      margin-top: 20px;
    }

    .video-item {
      margin-bottom: 30px;
      text-align: center;
      /* Centers the content inside video-item */
    }

    video {
      width: 95%;
      /* Set the desired width */
      /* height: 360px; */
      /* Set the desired height */
      margin: 0 auto;
      /* Centers the video */
    }
  </style>
</head>

<body class="nav-md">
  <div class="container body">
    <div class="main_container">
      <div class="col-md-3 left_col" style="background-color:#990;">
        <div class="left_col scroll-view">
          <?php include "navbar.php"; ?>
          <?php include "sidebar.php"; ?>
        </div>
      </div>

      <?php include "topbar.php"; ?>

      <div class="right_col" role="main">
        <br />
        <div class="container">
          <h1>Your Learning Videos</h1>

          <?php
          // Show success or error messages
          if (isset($_SESSION['message'])) {
            echo '<div class="alert alert-success alert-dismissible fade show" role="alert">'
              . $_SESSION['message'] .
              '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'
              . '<span aria-hidden="true">×</span>'
              . '</button></div>';
            unset($_SESSION['message']);
          }

          if (isset($_SESSION['error'])) {
            echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">'
              . $_SESSION['error'] .
              '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'
              . '<span aria-hidden="true">×</span>'
              . '</button></div>';
            unset($_SESSION['error']);
          }
          ?>

          <div class="container mt-5">
            <div class="row">
              <?php
              if (mysqli_num_rows($result) > 0) {
                while ($row = mysqli_fetch_assoc($result)) {
                  echo "<div class='col-md-4 mb-4'>"; // 3 cards per row
                  echo "  <div class='card  shadow-sm border-0 rounded-4'>";
                  echo "    <div class='card-body p-3'>";
                  echo "      <h5 class='card-title text-center mb-3'>" . htmlspecialchars($row['vname']) . "</h5>";
                  echo "      <div class='ratio ratio-16x9 mb-3 rounded overflow-hidden'>";
                  echo "        <video controls class='w-100 h-100' controlsList='nodownload'>
                        <source src='../upload/yourlearning/" . htmlspecialchars($row['vfilepath']) . "' type='video/mp4'>
                        Your browser does not support the video tag.
                      </video>";
                  echo "      </div>";
                  echo "      <p class='card-text text-muted'>" . htmlspecialchars($row['vdescription']) . "</p>";
                  echo "    </div>";
                  echo "  </div>";
                  echo "</div>";
                }
              } else {
                echo "<div class='col-12 text-center'><p>No videos uploaded yet.</p></div>";
              }
              ?>
            </div>
          </div>

        </div>


      </div>


    </div>
  </div>
  </div>
  <?php include "footer.php"; ?>
  <script src="../vendors/bootstrap/dist/js/bootstrap.min.js"></script>
  <script src="../vendors/fastclick/lib/fastclick.js"></script>
  <script src="../vendors/nprogress/nprogress.js"></script>
  <script src="../vendors/bootstrap-progressbar/bootstrap-progressbar.min.js"></script>
  <script src="js/custom.min.js"></script>
</body>

</html>

<?php
mysqli_close($conn);
?>