"use strict";





module.exports = function(Chart) {





	var helpers = Chart.helpers;


	// Default config for a category scale


	var defaultConfig = {


		position: "bottom"


	};





	var DatasetScale = Chart.Scale.extend({


		// Implement this so that 


		determineDataLimits: function() {


			this.minIndex = 0;


			this.maxIndex = this.chart.data.labels.length - 1;


			var findIndex;





			if (this.options.ticks.min !== undefined) {


				// user specified min value


				findIndex = helpers.indexOf(this.chart.data.labels, this.options.ticks.min);


				this.minIndex = findIndex !== -1 ? findIndex : this.minIndex;


			}





			if (this.options.ticks.max !== undefined) {


				// user specified max value


				findIndex = helpers.indexOf(this.chart.data.labels, this.options.ticks.max);


				this.maxIndex = findIndex !== -1 ? findIndex : this.maxIndex;


			}





			this.min = this.chart.data.labels[this.minIndex];


			this.max = this.chart.data.labels[this.maxIndex];


		},





		buildTicks: function(index) {


			// If we are viewing some subset of labels, slice the original array


			this.ticks = (this.minIndex === 0 && this.maxIndex === this.chart.data.labels.length - 1) ? this.chart.data.labels : this.chart.data.labels.slice(this.minIndex, this.maxIndex + 1);


		},





		getLabelForIndex: function(index, datasetIndex) {


			return this.ticks[index];


		},





		// Used to get data value locations.  Value can either be an index or a numerical value


		getPixelForValue: function(value, index, datasetIndex, includeOffset) {


			// 1 is added because we need the length but we have the indexes


			var offsetAmt = Math.max((this.maxIndex + 1 - this.minIndex - ((this.options.gridLines.offsetGridLines) ? 0 : 1)), 1);





			if (this.isHorizontal()) {


				var innerWidth = this.width - (this.paddingLeft + this.paddingRight);


				var valueWidth = innerWidth / offsetAmt;


				var widthOffset = (valueWidth * (index - this.minIndex)) + this.paddingLeft;





				if (this.options.gridLines.offsetGridLines && includeOffset) {


					widthOffset += (valueWidth / 2);


				}





				return this.left + Math.round(widthOffset);


			} else {


				var innerHeight = this.height - (this.paddingTop + this.paddingBottom);


				var valueHeight = innerHeight / offsetAmt;


				var heightOffset = (valueHeight * (index - this.minIndex)) + this.paddingTop;





				if (this.options.gridLines.offsetGridLines && includeOffset) {


					heightOffset += (valueHeight / 2);


				}





				return this.top + Math.round(heightOffset);


			}


		},


		getPixelForTick: function(index, includeOffset) {


			return this.getPixelForValue(this.ticks[index], index + this.minIndex, null, includeOffset);


		},


		getValueForPixel: function(pixel) {


			var value


;			var offsetAmt = Math.max((this.ticks.length - ((this.options.gridLines.offsetGridLines) ? 0 : 1)), 1);


			var horz = this.isHorizontal();


			var innerDimension = horz ? this.width - (this.paddingLeft + this.paddingRight) : this.height - (this.paddingTop + this.paddingBottom);


			var valueDimension = innerDimension / offsetAmt;





			if (this.options.gridLines.offsetGridLines) {


				pixel -= (valueDimension / 2);


			}


			pixel -= horz ? this.paddingLeft : this.paddingTop;





			if (pixel <= 0) {


				value = 0;


			} else {


				value = Math.round(pixel / valueDimension);


			}





			return value;


		}


	});





	Chart.scaleService.registerScaleType("category", DatasetScale, defaultConfig);





};