"use strict";





module.exports = function(Chart) {





	var helpers = Chart.helpers;





	var defaultConfig = {


		position: "left",





		// label settings


		ticks: {


			callback: function(value, index, arr) {


				var remain = value / (Math.pow(10, Math.floor(helpers.log10(value))));





				if (remain === 1 || remain === 2 || remain === 5 || index === 0 || index === arr.length - 1) {


					return value.toExponential();


				} else {


					return '';


				}


			}


		}


	};





	var LogarithmicScale = Chart.Scale.extend({


		determineDataLimits: function() {


			var _this = this;


			var opts = _this.options;


			var tickOpts = opts.ticks;


			var chart = _this.chart;


			var data = chart.data;


			var datasets = data.datasets;


			var getValueOrDefault = helpers.getValueOrDefault;


			var isHorizontal = _this.isHorizontal();


			function IDMatches(meta) {


				return isHorizontal ? meta.xAxisID === _this.id : meta.yAxisID === _this.id;


			}





			// Calculate Range


			_this.min = null;


			_this.max = null;





			if (opts.stacked) {


				var valuesPerType = {};





				helpers.each(datasets, function(dataset, datasetIndex) {


					var meta = chart.getDatasetMeta(datasetIndex);


					if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta)) {


						if (valuesPerType[meta.type] === undefined) {


							valuesPerType[meta.type] = [];


						}





						helpers.each(dataset.data, function(rawValue, index) {


							var values = valuesPerType[meta.type];


							var value = +_this.getRightValue(rawValue);


							if (isNaN(value) || meta.data[index].hidden) {


								return;


							}





							values[index] = values[index] || 0;





							if (opts.relativePoints) {


								values[index] = 100;


							} else {


								// Don't need to split positive and negative since the log scale can't handle a 0 crossing


								values[index] += value;


							}


						});


					}


				});





				helpers.each(valuesPerType, function(valuesForType) {


					var minVal = helpers.min(valuesForType);


					var maxVal = helpers.max(valuesForType);


					_this.min = _this.min === null ? minVal : Math.min(_this.min, minVal);


					_this.max = _this.max === null ? maxVal : Math.max(_this.max, maxVal);


				});





			} else {


				helpers.each(datasets, function(dataset, datasetIndex) {


					var meta = chart.getDatasetMeta(datasetIndex);


					if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta)) {


						helpers.each(dataset.data, function(rawValue, index) {


							var value = +_this.getRightValue(rawValue);


							if (isNaN(value) || meta.data[index].hidden) {


								return;


							}





							if (_this.min === null) {


								_this.min = value;


							} else if (value < _this.min) {


								_this.min = value;


							}





							if (_this.max === null) {


								_this.max = value;


							} else if (value > _this.max) {


								_this.max = value;


							}


						});


					}


				});


			}





			_this.min = getValueOrDefault(tickOpts.min, _this.min);


			_this.max = getValueOrDefault(tickOpts.max, _this.max);





			if (_this.min === _this.max) {


				if (_this.min !== 0 && _this.min !== null) {


					_this.min = Math.pow(10, Math.floor(helpers.log10(_this.min)) - 1);


					_this.max = Math.pow(10, Math.floor(helpers.log10(_this.max)) + 1);


				} else {


					_this.min = 1;


					_this.max = 10;


				}


			}


		},


		buildTicks: function() {


			var _this = this;


			var opts = _this.options;


			var tickOpts = opts.ticks;


			var getValueOrDefault = helpers.getValueOrDefault;





			// Reset the ticks array. Later on, we will draw a grid line at these positions


			// The array simply contains the numerical value of the spots where ticks will be


			var ticks = _this.ticks = [];





			// Figure out what the max number of ticks we can support it is based on the size of


			// the axis area. For now, we say that the minimum tick spacing in pixels must be 50


			// We also limit the maximum number of ticks to 11 which gives a nice 10 squares on


			// the graph





			var tickVal = getValueOrDefault(tickOpts.min, Math.pow(10, Math.floor(helpers.log10(_this.min))));





			while (tickVal < _this.max) {


				ticks.push(tickVal);





				var exp = Math.floor(helpers.log10(tickVal));


				var significand = Math.floor(tickVal / Math.pow(10, exp)) + 1;





				if (significand === 10) {


					significand = 1;


					++exp;


				}





				tickVal = significand * Math.pow(10, exp);


			}





			var lastTick = getValueOrDefault(tickOpts.max, tickVal);


			ticks.push(lastTick);





			if (!_this.isHorizontal()) {


				// We are in a vertical orientation. The top value is the highest. So reverse the array


				ticks.reverse();


			}





			// At this point, we need to update our max and min given the tick values since we have expanded the


			// range of the scale


			_this.max = helpers.max(ticks);


			_this.min = helpers.min(ticks);





			if (tickOpts.reverse) {


				ticks.reverse();





				_this.start = _this.max;


				_this.end = _this.min;


			} else {


				_this.start = _this.min;


				_this.end = _this.max;


			}


		},


		convertTicksToLabels: function() {


			this.tickValues = this.ticks.slice();





			Chart.Scale.prototype.convertTicksToLabels.call(this);


		},


		// Get the correct tooltip label


		getLabelForIndex: function(index, datasetIndex) {


			return +this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);


		},


		getPixelForTick: function(index, includeOffset) {


			return this.getPixelForValue(this.tickValues[index], null, null, includeOffset);


		},


		getPixelForValue: function(value, index, datasetIndex, includeOffset) {


			var _this = this;


			var innerDimension;


			var pixel;





			var start = _this.start;


			var newVal = +_this.getRightValue(value);


			var range = helpers.log10(_this.end) - helpers.log10(start);


			var paddingTop = _this.paddingTop;


			var paddingBottom = _this.paddingBottom;


			var paddingLeft = _this.paddingLeft;





			if (_this.isHorizontal()) {





				if (newVal === 0) {


					pixel = _this.left + paddingLeft;


				} else {


					innerDimension = _this.width - (paddingLeft + _this.paddingRight);


					pixel = _this.left + (innerDimension / range * (helpers.log10(newVal) - helpers.log10(start)));


					pixel += paddingLeft;


				}


			} else {


				// Bottom - top since pixels increase downard on a screen


				if (newVal === 0) {


					pixel = _this.top + paddingTop;


				} else {


					innerDimension = _this.height - (paddingTop + paddingBottom);


					pixel = (_this.bottom - paddingBottom) - (innerDimension / range * (helpers.log10(newVal) - helpers.log10(start)));


				}


			}





			return pixel;


		},


		getValueForPixel: function(pixel) {


			var _this = this;


			var offset;


			var range = helpers.log10(_this.end) - helpers.log10(_this.start);


			var value;


			var innerDimension;





			if (_this.isHorizontal()) {


				innerDimension = _this.width - (_this.paddingLeft + _this.paddingRight);


				value = _this.start * Math.pow(10, (pixel - _this.left - _this.paddingLeft) * range / innerDimension);


			} else {


				innerDimension = _this.height - (_this.paddingTop + _this.paddingBottom);


				value = Math.pow(10, (_this.bottom - _this.paddingBottom - pixel) * range / innerDimension) / _this.start;


			}





			return value;


		}


	});


	Chart.scaleService.registerScaleType("logarithmic", LogarithmicScale, defaultConfig);





};