<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>SMART WEALTH PLANNER - About Us</title>
  <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="assets/style.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    body {
      font-family: 'Poppins', sans-serif;
      background-color: #f8f9fa;
    }
    .section-title {
      font-size: 2.5rem;
      font-weight: 600;
      color: #fff;
      background: #e67e22;
      padding: 10px 20px;
      border-radius: 25px;
      text-align: center;
      margin-bottom: 3rem;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
    }
    .about-text h5 {
      color: #e67e22;
      font-weight: 600;
    }
    .about-text p {
      font-size: 1rem;
      font-weight: 500;
      color: #333;
    }
    .about-section {
      padding: 60px 0;
    }
    .img-fluid {
      border-radius: 12px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    }
    .instructor-section {
      padding: 60px 0;
      background-color: #fff;
    }
    .instructor-img {
      width: 100%;
      max-width: 400px;
      border-radius: 12px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    }
    .instructor-text h2 {
      font-size: 2rem;
      color: #e67e22;
      font-weight: 600;
    }
    .instructor-text p {
      font-size: 1rem;
      font-weight: 500;
      color: #333;
    }
  </style>
</head>
<body>

  <!-- Navigation Bar -->
  <?php include "./header.php"; ?>

  <!-- About Us Section -->
  <section class="about-section">
    <div class="container">
      <h2 class="section-title">About Company</h2>
      <div class="row align-items-center">
        <div class="col-lg-6 order-lg-1 order-2 about-text">
          <h5>1. Comprehensive Indian Stock Market Education:</h5>
          <p>Our company provides a range of online courses, catering to all levels from beginners to advanced traders, ensuring a strong foundation and skill enhancement for every learner since 2017.</p>

          <h5>2. Automatic Trading Guide Software:</h5>
          <p>Offering cutting-edge software solutions to simplify and guide automatic trading, we empower traders to make informed decisions with ease.</p>

          <h5>3. Experience and Expertise:</h5>
          <p>With over a decade of experience in the stock market, we have earned the trust of thousands by consistently educating and empowering traders and investors.</p>

          <h5>4. Networking and Business Opportunities:</h5>
          <p>As a networking company, we provide an innovative business model that combines education with an income opportunity for distributors and associates.</p>

          <h5>5. Instant and Easy Pay-outs:</h5>
          <p>Distributors enjoy the benefit of hassle-free, instant pay-outs from day one—a visionary approach offering a dual benefit: Education and business income.</p>
        </div>
        <div class="col-lg-6 order-lg-2 order-1 mb-4 mb-lg-0 text-center">
          <img src="assets/logo1.png" alt="SMART WEALTH PLANNER" class="img-fluid">
        </div>
      </div>
    </div>
  </section>

  <!-- Our Value Section -->
  <?php include "ourvalue.php"; ?>

  <!-- Instructor Section -->
    <section id="instructor" class="py-5 bg-white">
        <div class="container text-center">
            <h2 class="text-center section-title display-6 fw-bold">Meet Your Instructor</h2>
            <div class="row align-items-center">
                <div class="col-lg-4 text-lg-end">
                    <img src="assets/instructor1.jpg" alt="Instructor" class="instructor-img shadow" style="width:60%;">
                </div>
                <div class="col-lg-8 text-lg-start mt-lg-0 mt-4">
                    <h3 class="fw-bold">Mr. Vaibhav Thakur</h3>
                    <p class="text-muted mb-4">Professional Trader & trainer</p>
                    <p class="mb-4">Mr. Vaibhav Thakur is a seasoned stock market trader and trainer based in Nashik,
                        Maharashtra. With over a decade of experience in the finance industry, he specializes in equity,
                        derivatives, and commodity markets. He holds certifications in NISM Equity and Derivatives,
                        establishing himself as a subject matter expert.</p>
                    <p class="mb-4">Vaibhav is the Business Owner of SV LIVE TRADE since March 2010 and has been
                        involved with Heartbeats Animation since February 2009. He has trained over 5,000 stock market
                        learners and is known for his roles as a trader, trainer, and mentor.</p>
                    <!-- <div class="row g-4 mt-4">
                        <div class="col-md-4">
                            <div class="fw-bold fs-3">18M+</div>
                            <p class="text-muted mb-0">Quora Views</p>
                        </div>
                        <div class="col-md-4">
                            <div class="fw-bold fs-3">7+</div>
                            <p class="text-muted mb-0">Best-Selling Books</p>
                        </div>
                        <div class="col-md-4">
                            <div class="fw-bold fs-3">15+</div>
                            <p class="text-muted mb-0">Years Experience</p>
                        </div>
                    </div> -->
                </div>
            </div>
			<div class="row g-4 mt-4">
                    <div class="col-md-4">
                        <div class="fw-bold fs-3">5,000+</div>
                        <p class="text-muted mb-0">People Trained</p>
                    </div>
                    <div class="col-md-4">
                        <div class="fw-bold fs-3">15+</div>
                        <p class="text-muted mb-0">Years Experience</p>
                    </div>
                    <div class="col-md-4">
                        <div class="fw-bold fs-3">100%</div>
                        <p class="text-muted mb-0">Practical Approach</p>
                    </div>
                </div>
            
		<br>
		<h3 class="text-center " style="background:#ddd;">Our SEBI & NISM Certifications</h3>
		<div class="row">
			<div class="col-md-6">
			<img src="assets/cert1.jpeg" alt="Events"  style="width:100%;">
			</div>
			<div class="col-md-6">
			<img src="assets/cert2.jpeg" alt="Events"  style="width:100%;">
			</div>
		</div>
        </div>
    </section>
	
	<!-- Testimonials Section -->
     <section id="testimonials" class="py-5 bg-light">
        <div class="container">
            <h2 class="text-center section-title display-6 fw-bold">Glimpse of our Past  Events</h2>            
            <div class="row">
                <div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_1.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
                <div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_2.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
                <div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_3.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
				<div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_4.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
				<div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_5.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
				<div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_6.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
				<div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_7.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
				<div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_8.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
				<div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_9.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
            </div>
        </div>
    </section> 


  <!-- Footer -->
  <?php include "./footer.php"; ?>

  <script src="bootstrap/js/bootstrap.bundle.min.js"></script>
</body>
</html>
