<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>SMART WEALTH PLANNER - Premium Stock Market Courses</title>
  <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="assets/style.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    body {
      font-family: 'Poppins', sans-serif;
      background-color: #f8f9fa;
    }
    .section-title {
      font-size: 2.5rem;
      font-weight: 600;
      color: #fff;
      background: #e67e22;
      padding: 10px 20px;
      border-radius: 25px;
      text-align: center;
      margin-bottom: 3rem;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
    }
    .referral-diagram {
      position: relative;
      text-align: center;
      margin-bottom: 2rem;
    }
    .user-node {
      width: 50px;
      height: 50px;
      background: #e67e22;
      color: #fff;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      font-weight: 600;
      position: relative;
      margin: 0 auto;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
      transition: transform 0.3s ease;
    }
    .user-node:hover {
      transform: scale(1.1);
    }
    .level-1, .level-2, .level-3 {
      display: flex;
      justify-content: center;
      gap: 50px;
      margin-top: 30px;
    }
    .level-2 {
      gap: 30px;
    }
    .level-3 {
      gap: 20px;
    }
    .connector {
      position: absolute;
      background: #e67e22;
      transform-origin: top;
    }
    .connector-diagonal-left {
      width: 2px;
      height: 50px;
      transform: rotate(45deg);
    }
    .connector-diagonal-right {
      width: 2px;
      height: 50px;
      transform: rotate(-45deg);
    }
    .table-container {
      background: #fff;
      border-radius: 12px;
      padding: 20px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
      margin-bottom: 2rem;
    }
    .table th {
      background: #e67e22;
      color: #fff;
      font-weight: 600;
      text-align: center;
    }
    .table td {
      text-align: center;
      font-weight: 500;
    }
    .income-details {
      background: #fff;
      border: 2px solid #e67e22;
      border-radius: 12px;
      padding: 20px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
      margin-bottom: 2rem;
    }
    .income-details p {
      margin: 5px 0;
      font-weight: 500;
    }
    .income-calculation {
      background: #e67e22;
      color: #fff;
      border-radius: 12px;
      padding: 15px;
      text-align: center;
      font-weight: 600;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
    }
    @media (max-width: 768px) {
      .level-1, .level-2, .level-3 {
        gap: 20px;
      }
      .user-node {
        width: 40px;
        height: 40px;
        font-size: 0.9rem;
      }
      .connector-diagonal-left,
      .connector-diagonal-right {
        height: 30px;
      }
      .section-title {
        font-size: 1.8rem;
      }
      .table th, .table td {
        font-size: 0.9rem;
      }
    }
  </style>
</head>
<body>
      <!-- Navigation Bar -->
      <?php
    include "./header.php"
        ?>
  <section class="py-5">
    <div class="container">
      <h2 class="section-title animate__animated animate__fadeIn">Our Business Plan</h2>
      <div class="row">
        <!-- Referral Diagram -->
        <div class="col-md-6 referral-diagram">
          <div class="user-node">U</div>
          <div class="level-1">
            <div class="user-node">A</div>
            <div class="user-node">B</div>
          </div>
          <div class="level-2">
            <div class="user-node">C</div>
            <div class="user-node">E</div>
            <div class="user-node">D</div>
            <div class="user-node">F</div>
          </div>
          <div class="level-3">
            <div class="user-node">G</div>
            <div class="user-node">L</div>
            <div class="user-node">H</div>
            <div class="user-node">M</div>
            <div class="user-node">I</div>
            <div class="user-node">J</div>
            <div class="user-node">N</div>
            <div class="user-node">K</div>
          </div>
          <!-- Connectors -->
          <div class="connector connector-diagonal-left" style="top: 50px; left: 48%;"></div>
          <div class="connector connector-diagonal-right" style="top: 50px; right: 48%;"></div>
          <div class="connector connector-diagonal-left" style="top: 130px; left: 36%;"></div>
          <div class="connector connector-diagonal-right" style="top: 130px; left: 48%;"></div>
          <div class="connector connector-diagonal-left" style="top: 130px; right: 48%;"></div>
          <div class="connector connector-diagonal-right" style="top: 130px; right: 36%;"></div>
        </div>
        <!-- Payout Table -->
        <div class="col-md-6">
          <div class="table-container">
            <table class="table table-bordered">
              <thead>
                <tr>
                  <th>CLOSING TIME</th>
                  <th>MATCHING PAIR</th>
                  <th>PAYOUT RS.</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td>3:00 AM TO 9:00 AM</td>
                  <td>1</td>
                  <td>1,000</td>
                </tr>
                <tr>
                  <td>9:00 AM TO 3:00 PM</td>
                  <td>1</td>
                  <td>1,000</td>
                </tr>
                <tr>
                  <td>3:00 PM TO 9:00 PM</td>
                  <td>1</td>
                  <td>1,000</td>
                </tr>
                <tr>
                  <td>9:00 AM TO 3:00 AM</td>
                  <td>1</td>
                  <td>1,000</td>
                </tr>
                <tr>
                  <td>24 HRS</td>
                  <td>4</td>
                  <td>4,000</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
      <!-- Income Details -->
      <div class="row">
        <div class="col-md-6">
          <div class="income-details">
            <p>Pair matching in the same time cycles = 1000</p>
            <p>Maximum payout in single time cycle = 1000</p>
            <p>Maximum Daily payout = 4000</p>
          </div>
        </div>
        <div class="col-md-6">
          <div class="income-calculation">
            <p>Per Day Income = Rs. 4,000/-</p>
            <p>30 days Income = Rs. 1,20,000/-</p>
            <p>3 ID's X 1,20,000 = 3,60,000/-</p>
            <p>7 ID's X 1,20,000 = 8,40,000/-</p>
          </div>
        </div>
      </div>
    </div>
  </section>
  
  <section class="py-5" style="background:white;">
    <div class="container">
      <div class="row">
        <!-- Award Graphic -->
        <div class="col-md-6 mb-4 mb-md-0">
          <div class="award-section">
            <!-- <h2>Award & Reward</h2> -->
             <img src="assets/award.png" width="100%" alt="">
          </div>
        </div>
        <!-- Reward Table -->
        <div class="col-md-6">
          <div class="table-container">
            <table class="table table-bordered">
              <thead>
                <tr>
                  <th>SR.</th>
                  <th>RANK</th>
                  <th>PAIR</th>
                  <th>GIFT</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td>1</td>
                  <td>STAR</td>
                  <td>50</td>
                  <td>500</td>
                </tr>
                <tr>
                  <td>2</td>
                  <td>EXECUTIVE</td>
                  <td>100</td>
                  <td>1,000</td>
                </tr>
                <tr>
                  <td>3</td>
                  <td>SILVER</td>
                  <td>250</td>
                  <td>2,500</td>
                </tr>
                <tr>
                  <td>4</td>
                  <td>GOLD</td>
                  <td>500</td>
                  <td>5,000</td>
                </tr>
                <tr>
                  <td>5</td>
                  <td>PEARL</td>
                  <td>1000</td>
                  <td>10,000</td>
                </tr>
                <tr>
                  <td>6</td>
                  <td>EMRALD</td>
                  <td>2500</td>
                  <td>25,000</td>
                </tr>
                <tr>
                  <td>7</td>
                  <td>PLATINUM</td>
                  <td>5000</td>
                  <td>50,000</td>
                </tr>
                <tr>
                  <td>8</td>
                  <td>DAIMOND</td>
                  <td>10000</td>
                  <td>1,00,000</td>
                </tr>
                <tr>
                  <td>9</td>
                  <td>BLUE DAIMOND</td>
                  <td>25000</td>
                  <td>2,50,000</td>
                </tr>
                <tr>
                  <td>10</td>
                  <td>ROYAL DAIMOND</td>
                  <td>50000</td>
                  <td>5,00,000</td>
                </tr>
                <tr>
                  <td>11</td>
                  <td>CROWN DAIMOND</td>
                  <td>100000</td>
                  <td>10,00,000</td>
                </tr>
                <tr>
                  <td>12</td>
                  <td>KOHINOOR DAIMOND</td>
                  <td>500000</td>
                  <td>50,00,000</td>
                </tr>
                <tr>
                  <td>13</td>
                  <td>DIRECTOR</td>
                  <td>1000000</td>
                  <td>1,00,00,000</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
      <!-- Note -->
      <div class="text-center">
        <span class="note">Note - Award & Reward count is a next to next</span>
      </div>
    </div>
  </section>
  
  <section class="py-5">
    <div class="container">
      <div class="terms-section">
        <h2 class="section-title animate__animated animate__fadeIn">Binary Commission Partner Term & Condition</h2>
        <ul class="terms-list">
          <li>
            Daily 4 Cycles for Binary Income:
            <ul>
              <li>(1) 3:00 AM to 9:00 AM</li>
              <li>(2) 9:00 AM to 3:00 PM</li>
              <li>(3) 3:00 PM to 9:00 PM</li>
              <li>(4) 9:00 PM to 3:00 AM</li>
            </ul>
          </li>
          <li>PAYOUT ELIGIBILITY: Left and Right Pair matching in the same time cycle is mandatory.</li>
          <li>MAXIMUM PAYOUT Per Cycle: 1 pair matching income (INR 1000/-).</li>
          <li>MAXIMUM PAYOUT Per Day: 4 pair matching income (INR 4000/-).</li>
          <li>PAYOUT TRANSFER: Payments will be processed and transferred to your bank account within 72 hours.</li>
          <li>Direct Pair Matching INCOME: Maximum of 10 levels.</li>
          <li>ADMIN CHARGES: 15% will be deducted from your commission payout.</li>
          <li>KYC REQUIREMENT: Bank KYC is mandatory to receive payouts.</li>
          <li>ACCESS to PRODUCTS: SWP Education Courses and Software will be available in your web login portal.</li>
          <li>PIN GENERATION REQUEST TIMING: Daily from 9:00 AM to 9:00 PM.</li>
        </ul>
      </div>
    </div>
  </section>
   <!-- Footer -->
   <?php include "./footer.php" ?>
<script src="bootstrap/js/bootstrap.bundle.min.js"></script>
</body>
</html>