<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SMART WEALTH PLANNER - Premium Stock Market Courses</title>
    <!-- Bootstrap 5 CSS -->
    <!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"> -->
    <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/style.css">
    <style>
    </style>
</head>
<body>
    <!-- Navigation Bar -->
    <?php
    include "./header.php"
        ?>
        
    <!-- Hero Section -->
    <section id="home" class="hero text-center">
        <div class="container">
            <div class="hero-content">
                <h1 class="display-4 fw-bold mb-4">WATCH, LEARN, TRADE</h1>
                <p class="lead fs-3 mb-4">Access the market-leading online course, at lowest cost</p>
                <p class="fs-5 mb-5">Take advantage of unlimited investment potential, recognise market opportunities
                    and make informed decisions with confidence.</p>
                <p class="fs-5 mb-5">With over 10 years of experience training traders, SMART WEALTH PLANNER's online video course
                    is the perfect base upon which to build your knowledge.</p>
                <p class="fs-5 mb-5">Enjoy <b>3 Courses with over 100+ Lessons</b> curated by professional trading coaches and start making informed trading & investment decisions today.</p>
                <div class="row justify-content-center ">
                   <div class="col-md-4 col-xs-3"> 
                    <a href="#courses" class="btn btn-primary btn-lg px-4 py-3">Explore Courses</a>
					</div>
					<div class="col-md-4 col-xs-3"> 
					<a href="#software" class="btn btn-warning btn-lg px-4 py-3">Explore Software</a>
					</div>
					<div class="col-md-4 col-xs-3"> 
					<a href="#businessplan" class="btn btn-success btn-lg px-4 py-3">Explore Business Plan</a>
					</div>
					<!--<div class="col-md-3 col-xs-3"> 
					<a href="../member/login.php" class="btn btn-danger btn-lg px-4 py-3">Member Login</a>
					</div>-->
                </div>
            </div>
        </div>
    </section>
    <!-- Welcome Section -->
    <section id="about" class="py-5 bg-white">
        <div class="container">
            <h2 class="text-center section-title display-6 fw-bold">Welcome to Stock Market Courses E-Learning</h2>
            <p class="text-center fs-5 mb-5 mx-auto" style="max-width: 800px;">
			Traditional savings no longer keep pace with rising costs, and gold's stability cant guarantee growth. Real estate requires deep pockets and carries uncertainties. So what's the smart move?  <br>			
			<span class="fw-bold text-primary">The answer is, "SMART WEALTH PLANNER!"</span></p>
            <div class="row g-4">
                <div class="col-md-3 text-center">
                    <div class="feature-icon">
                        <i class="fas fa-chalkboard-teacher"></i>
                    </div>
                    <h3 class="h5 fw-bold">Expert Instructor</h3>
                    <p>Learn from full-time trader & NISM certified Market Expert with proven track records.</p>
                </div>
                <div class="col-md-3 text-center">
                    <div class="feature-icon">
                        <i class="fas fa-trophy"></i>
                    </div>
                    <h3 class="h5 fw-bold">Award Winning</h3>
                    <p>Recognized as the best trading education courses for 3 consecutive years.</p>
                </div>
                <div class="col-md-3 text-center">
                    <div class="feature-icon">
                        <i class="fas fa-book-open"></i>
                    </div>
                    <h3 class="h5 fw-bold">Comprehensive Curriculum</h3>
                    <p>Courses covering all aspects - from basics to advanced trading strategies.</p>
                </div>
                <div class="col-md-3 text-center">
                    <div class="feature-icon">
                        <i class="fas fa-headset"></i>
                    </div>
                    <h3 class="h5 fw-bold">24/7 Support</h3>
                    <p>Dedicated support team to help you throughout your learning journey.</p>
                </div>
            </div>
        </div>
    </section>
     <!-- Courses Section -->
    <section id="courses" class="py-5 bg-light">
        <div class="container">
            <h2 class="text-center section-title display-6 fw-bold">Our Popular Courses</h2>
            <p class="text-center mb-5 mx-auto" style="max-width: 700px;">Choose from our carefully crafted courses
                designed to take you from beginner to expert trader. All courses come with lifetime access and free
                updates.</p>
            <div class="row g-4">
                <!-- Course 1 -->
                <div class="col-md-4">
                    <div class="course-card card h-100 shadow-sm">
                        <div class="position-relative">
                            <!-- <img src="assets/basic.jfif" class="card-img-top" alt="Course Image"> -->
                            <img src="assets/basic.jfif" class="card-img-top" alt="Course Image"
                             style="width: 100%; height: auto; aspect-ratio: 16/9; object-fit: contain; background-color: #f9f9f9;">

                            <span class="badge badge-discount badge-pill">75% OFF</span>
                        </div>
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <span class="badge bg-primary">Bestseller</span>
                                <span class="text-muted"><i class="fas fa-users"></i> 2.5K+ Students</span>
                            </div>
                            <h3 class="card-title h5 fw-bold">Beginner Course - From basic to smart investor path</h3>
                            <p class="card-text text-muted">by Mr. Vaibhav Thakur</p>
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <p class="card-text fs-5 fw-bold text-primary mb-0">₹2,500 <span
                                        class="text-decoration-line-through text-muted fs-6">₹10,000</span></p>
                                <p class="star-rating mb-0"><i class="fas fa-star"></i> 4.9 (751)</p>
                            </div>
                            <div class="d-grid">
                                <a href="#register" class="btn btn-primary">Enroll Now</a>
                            </div>
                        </div>
                        <div class="card-footer bg-white border-top-0">
                            <div class="d-flex justify-content-between">
                                <small class="text-muted"><i class="far fa-clock me-1"></i> 32 Videos</small>
                                <small class="text-muted"><i class="far fa-play-circle me-1"></i> 12 Modules</small>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Course 2 -->
                <div class="col-md-4">
                    <div class="course-card card h-100 shadow-sm">
                        <div class="position-relative">
                            <img src="assets/intra1.jpg" style="width: 95%;" class="card-img-top" alt="Course Image">
                            <span class="badge badge-discount badge-pill">75% OFF</span>
                        </div>
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-2">
							<span class="badge bg-warning text-dark">Trending</span>
                                
                                <span class="text-muted"><i class="fas fa-users"></i> 1.8K+ Students</span>
                            </div>
                            <h3 class="card-title h5 fw-bold">Advanced Couse - Professional Intraday trading strategies </h3>
                            <p class="card-text text-muted">by Mr. Vaibhav Thakur</p>
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <p class="card-text fs-5 fw-bold text-primary mb-0">₹2,500 <span
                                        class="text-decoration-line-through text-muted fs-6">₹10,000</span></p>
                                <p class="star-rating mb-0"><i class="fas fa-star"></i> 4.8 (649)</p>
                            </div>
                            <div class="d-grid">
                                <a href="#register" class="btn btn-primary">Enroll Now</a>
                            </div>
                        </div>
                        <div class="card-footer bg-white border-top-0">
                            <div class="d-flex justify-content-between">
                                <small class="text-muted"><i class="far fa-clock me-1"></i> 18 Videos</small>
                                <small class="text-muted"><i class="far fa-play-circle me-1"></i> 10 Modules</small>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Course 3 -->
                <div class="col-md-4">
                    <div class="course-card card h-100 shadow-sm">
                        <div class="position-relative">
                            <img src="assets/option.jfif"  class="card-img-top" alt="Course Image">
                            <span class="badge badge-discount badge-pill">75% OFF</span>
                        </div>
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <span class="badge bg-success">New</span>
                                <span class="text-muted"><i class="fas fa-users"></i> 2.1K+ Students</span>
                            </div>
                            <h3 class="card-title h5 fw-bold">Option Expert - Option Trading Master Class</h3>
                            <p class="card-text text-muted">by Vaibhav Thakur</p>
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <p class="card-text fs-5 fw-bold text-primary mb-0">₹2,500 <span
                                        class="text-decoration-line-through text-muted fs-6">₹10,000</span></p>
                                <p class="star-rating mb-0"><i class="fas fa-star"></i> 4.9 (819)</p>
                            </div>
                            <div class="d-grid">
                                <a href="#register" class="btn btn-primary">Enroll Now</a>
                            </div>
                        </div>
                        <div class="card-footer bg-white border-top-0">
                            <div class="d-flex justify-content-between">
                                <small class="text-muted"><i class="far fa-clock me-1"></i> 20 Videos</small>
                                <small class="text-muted"><i class="far fa-play-circle me-1"></i> 8 Modules</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--<div class="text-center mt-5">
                <a href="#" class="btn btn-outline-primary btn-lg">View All Courses <i
                        class="fas fa-arrow-right ms-2"></i></a>
            </div>-->
        </div>
    </section>

<!-- stock cource -->
<?php
//include "stock-cource.php";
?>
<!-- advertisement-banner -->
<?php
include "advertisement-banner.php";
?>
<!-- our-service -->
<?php
//include "our-service.php";
?>
    <!-- Stats Section -->
    <!-- <section class="py-5 bg-light">
        <div class="container">
            <div class="row g-4">
                <div class="col-md-3">
                    <div class="stats-item">
                        <div class="stats-number">25+</div>
                        <p class="mb-0 fw-bold">Years Experience</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stats-item">
                        <div class="stats-number">50K+</div>
                        <p class="mb-0 fw-bold">Students Trained</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stats-item">
                        <div class="stats-number">12+</div>
                        <p class="mb-0 fw-bold">Courses Available</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stats-item">
                        <div class="stats-number">4.9</div>
                        <p class="mb-0 fw-bold">Average Rating</p>
                    </div>
                </div>
            </div>
        </div>
    </section> -->
    
   
    <!-- Instructor Section -->
    <section id="instructor" class="py-5 bg-white">
        <div class="container text-center">
            <h2 class="text-center section-title display-6 fw-bold">Meet Your Instructor</h2>
            <div class="row align-items-center">
                <div class="col-lg-4 text-lg-end">
                    <img src="assets/instructor1.jpg" alt="Instructor" class="instructor-img shadow">
                </div>
                <div class="col-lg-8 text-lg-start mt-lg-0 mt-4">
                    <h3 class="fw-bold">Mr. Vaibhav Thakur</h3>
                    <p class="text-muted mb-4">Professional Trader & trainer</p>
                    <p class="mb-4">Mr. Vaibhav Thakur is a seasoned stock market trader and trainer based in Nashik,
                        Maharashtra. With over a decade of experience in the finance industry, he specializes in equity,
                        derivatives, and commodity markets. He holds certifications in NISM Equity and Derivatives,
                        establishing himself as a subject matter expert.</p>
                    <p class="mb-4">Vaibhav is the Business Owner of SV LIVE TRADE since March 2010 and has been
                        involved with Heartbeats Animation since February 2009. He has trained over 5,000 stock market
                        learners and is known for his roles as a trader, trainer, and mentor.</p>
                    <!-- <div class="row g-4 mt-4">
                        <div class="col-md-4">
                            <div class="fw-bold fs-3">18M+</div>
                            <p class="text-muted mb-0">Quora Views</p>
                        </div>
                        <div class="col-md-4">
                            <div class="fw-bold fs-3">7+</div>
                            <p class="text-muted mb-0">Best-Selling Books</p>
                        </div>
                        <div class="col-md-4">
                            <div class="fw-bold fs-3">15+</div>
                            <p class="text-muted mb-0">Years Experience</p>
                        </div>
                    </div> -->
                </div>
            </div>
			<div class="row g-4 mt-4">
                    <div class="col-md-4">
                        <div class="fw-bold fs-3">5,000+</div>
                        <p class="text-muted mb-0">People Trained</p>
                    </div>
                    <div class="col-md-4">
                        <div class="fw-bold fs-3">15+</div>
                        <p class="text-muted mb-0">Years Experience</p>
                    </div>
                    <div class="col-md-4">
                        <div class="fw-bold fs-3">100%</div>
                        <p class="text-muted mb-0">Practical Approach</p>
                    </div>
                </div>
            <div class="mt-5">
            <a href="topic.php" class="btn btn-primary btn-lg px-5">Explore Our Programs <i class="fas fa-arrow-right ms-2"></i></a>
        </div>
        </div>
    </section>




    <section id="software" class="py-5 bg-white">
    <div class="container text-center">
        <h2 class="text-center section-title display-6 fw-bold">Our Software</h2>
        <div class="row align-items-center">
            <div class="col-lg-4 text-lg-end">
                <img src="assets/trading.jpg" style=" width:100%;" alt="SWP Software & Indicator" class="instructor-img1 shadow">
            </div>
            <div class="col-lg-8 text-lg-start mt-lg-0 mt-4">
                <h3 class="fw-bold">SWP Software & Indicator</h3>
                <p class="mb-4">Unlock the power of informed investing with our TradingView indicator, designed for ETF and stock investments. Get actionable signals for intraday trading and long-term investments.</p>

                <h5 class="fw-bold mb-2">Key Features</h5>
                <ul class="text-start mb-4">
                    <li> <b>Proven Stock Selection Method </b> : <br>
					Our indicator uses a tested approach to identify high-potential stocks.</li><br>
                    <li> <b> ETF and Stock Signals </b>:  <br>
					Receive timely signals for both ETFs and stocks.</li><bR>
                    <li> <b> Intraday Trading Signals </b>: <bR>
					Make informed decisions for intraday trades.</li><bR>
                    <li> <b> Mobile and PC Compatibility </b>: <bR>
					Access our indicator on your mobile, laptop, or PC.</li>
                </ul>
               
			</div>
		</div><hr>
		<div class="row">
			<div class="col-md-8" align="left">
			 <h5 class="fw-bold mb-2">Course and Software</h5>
                <p class="mb-4">Our comprehensive course teaches you how to use our indicator effectively. The software is user-friendly and accessible on multiple platforms.</p><br>
                <h5 class="fw-bold mb-2">Benefits</h5>
                <ul class="text-start mb-4">
                    <li><b> Informed Investment Decisions </b>: Make data-driven decisions with our indicator.</li>
                    <li><b> Increased Confidence </b>: Our proven method helps you navigate the markets with confidence.</li>
                    <li><b> Flexibility </b>: Use our indicator on-the-go or from the comfort of your PC.</li>
                </ul>

                <p class="mb-4 fw-semibold">Get Started Today<br>Learn more about our TradingView indicator and course. Start making informed investment decisions and take your trading to the next level.</p>
            </div>
			<div class="col-lg-4 text-lg-end"><br><br>
                <img src="assets/trade.png" style=" width:100%;" alt="SWP Software & Indicator" class="instructor-img1 shadow">
            </div>
			
        </div>        
    </div>
</section>


	<style>
    body {
      font-family: 'Poppins', sans-serif;
      background-color: #f8f9fa;
    }
    .section-title {
      font-size: 2.5rem;
      font-weight: 600;
      color: #fff;
      background: #e67e22;
      padding: 10px 20px;
      border-radius: 25px;
      text-align: center;
      margin-bottom: 3rem;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
    }
    .referral-diagram {
      position: relative;
      text-align: center;
      margin-bottom: 2rem;
    }
    .user-node {
      width: 50px;
      height: 50px;
      background: #e67e22;
      color: #fff;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      font-weight: 600;
      position: relative;
      margin: 0 auto;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
      transition: transform 0.3s ease;
    }
    .user-node:hover {
      transform: scale(1.1);
    }
    .level-1, .level-2, .level-3 {
      display: flex;
      justify-content: center;
      gap: 50px;
      margin-top: 30px;
    }
    .level-2 {
      gap: 30px;
    }
    .level-3 {
      gap: 20px;
    }
    .connector {
      position: absolute;
      background: #e67e22;
      transform-origin: top;
    }
    .connector-diagonal-left {
      width: 2px;
      height: 50px;
      transform: rotate(45deg);
    }
    .connector-diagonal-right {
      width: 2px;
      height: 50px;
      transform: rotate(-45deg);
    }
    .table-container {
      background: #fff;
      border-radius: 12px;
      padding: 20px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
      margin-bottom: 2rem;
    }
    .table th {
      background: #e67e22;
      color: #fff;
      font-weight: 600;
      text-align: center;
    }
    .table td {
      text-align: center;
      font-weight: 500;
    }
    .income-details {
      background: #fff;
      border: 2px solid #e67e22;
      border-radius: 12px;
      padding: 20px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
      margin-bottom: 2rem;
    }
    .income-details p {
      margin: 5px 0;
      font-weight: 500;
    }
    .income-calculation {
      background: #e67e22;
      color: #fff;
      border-radius: 12px;
      padding: 15px;
      text-align: center;
      font-weight: 600;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
    }
    @media (max-width: 768px) {
      .level-1, .level-2, .level-3 {
        gap: 20px;
      }
      .user-node {
        width: 40px;
        height: 40px;
        font-size: 0.9rem;
      }
      .connector-diagonal-left,
      .connector-diagonal-right {
        height: 30px;
      }
      .section-title {
        font-size: 1.8rem;
      }
      .table th, .table td {
        font-size: 0.9rem;
      }
    }
  </style>
	<section class="py-5" id="businessplan">
    <div class="container">
      <h2 class="section-title animate__animated animate__fadeIn">Our Business Plan</h2>
      <div class="row">
        <!-- Referral Diagram -->
        <div class="col-md-6 referral-diagram">
          <div class="user-node">U</div>
          <div class="level-1">
            <div class="user-node">A</div>
            <div class="user-node">B</div>
          </div>
          <div class="level-2">
            <div class="user-node">C</div>
            <div class="user-node">E</div>
            <div class="user-node">D</div>
            <div class="user-node">F</div>
          </div>
          <div class="level-3">
            <div class="user-node">G</div>
            <div class="user-node">L</div>
            <div class="user-node">H</div>
            <div class="user-node">M</div>
            <div class="user-node">I</div>
            <div class="user-node">J</div>
            <div class="user-node">N</div>
            <div class="user-node">K</div>
          </div>
          <!-- Connectors -->
          <div class="connector connector-diagonal-left" style="top: 50px; left: 48%;"></div>
          <div class="connector connector-diagonal-right" style="top: 50px; right: 48%;"></div>
          <div class="connector connector-diagonal-left" style="top: 130px; left: 36%;"></div>
          <div class="connector connector-diagonal-right" style="top: 130px; left: 48%;"></div>
          <div class="connector connector-diagonal-left" style="top: 130px; right: 48%;"></div>
          <div class="connector connector-diagonal-right" style="top: 130px; right: 36%;"></div>
        </div>
        <!-- Payout Table -->
        <div class="col-md-6">
          <div class="table-container">
            <table class="table table-bordered">
              <thead>
                <tr>
                  <th>CLOSING TIME</th>
                  <th>MATCHING PAIR</th>
                  <th>PAYOUT RS.</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td>3:00 AM TO 9:00 AM</td>
                  <td>1</td>
                  <td>1,000</td>
                </tr>
                <tr>
                  <td>9:00 AM TO 3:00 PM</td>
                  <td>1</td>
                  <td>1,000</td>
                </tr>
                <tr>
                  <td>3:00 PM TO 9:00 PM</td>
                  <td>1</td>
                  <td>1,000</td>
                </tr>
                <tr>
                  <td>9:00 AM TO 3:00 AM</td>
                  <td>1</td>
                  <td>1,000</td>
                </tr>
                <tr>
                  <td>24 HRS</td>
                  <td>4</td>
                  <td>4,000</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
      <!-- Income Details -->
      <div class="row">
        <div class="col-md-6">
          <div class="income-details">
            <p>Pair matching in the same time cycles = 1000</p>
            <p>Maximum payout in single time cycle = 1000</p>
            <p>Maximum Daily payout = 4000</p>
          </div>
        </div>
        <div class="col-md-6">
          <div class="income-calculation">
            <p>Per Day Income = Rs. 4,000/-</p>
            <p>30 days Income = Rs. 1,20,000/-</p>
            <p>3 ID's X 1,20,000 = 3,60,000/-</p>
            <p>7 ID's X 1,20,000 = 8,40,000/-</p>
          </div>
        </div>
      </div>
    </div>
  </section>
    <!-- Testimonials Section -->
     <section id="testimonials" class="py-5 bg-light">
        <div class="container">
            <h2 class="text-center section-title display-6 fw-bold">Glimpse of Past  Events</h2>            
            <div class="row">
                <div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_1.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
                <div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_2.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
                <div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_3.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
				<div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_4.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
				<div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_5.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
				<div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_6.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
				<div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_7.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
				<div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_8.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
				<div class="col-md-4 mb-4">                    
                        <div class="text-center">
						<img src="assets/event_9.jpeg" alt="Events"  style="width:100%;">
                        </div>                    
                </div>
            </div>
        </div>
    </section> 
    <!-- Newsletter Section -->
    <section class="py-5">
        <div class="container">
            <div class="newsletter p-4 p-lg-5">
                <div class="row align-items-center">
                    <div class="col-lg-6 text-center text-lg-start mb-lg-0 mb-4">
                        <h3 class="fw-bold mb-3">Call to Action</h3>
                        <p class="mb-0">Exclusive stock Market courses - Basic to Advanced with affordable price and Free Trading view Software and Indicator.</p>
                    </div>
                    <div class="col-lg-6">
                        <form class="row g-2">                           
                            <div class="col-md-4">
                                <button type="submit" class="btn btn-light w-100">Join Now</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- FAQ Section -->
    <section class="py-5 bg-white">
        <div class="container">
            <h2 class="text-center section-title display-6 fw-bold">Frequently Asked Questions</h2>
            <div class="row justify-content-center mt-5">
                <div class="col-lg-8">
                    <div class="accordion" id="faqAccordion">
                        <!-- FAQ Item 1 -->
                        <div class="accordion-item mb-3 border-0 shadow-sm">
                            <h2 class="accordion-header" id="headingOne">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseOne">
                                    Who should take these stock market courses?
                                </button>
                            </h2>
                            <div id="collapseOne" class="accordion-collapse collapse" aria-labelledby="headingOne"
                                data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    Our courses are designed for everyone - from absolute beginners who have never
                                    traded before to intermediate traders looking to refine their strategies. We have
                                    different courses tailored for different experience levels.
                                </div>
                            </div>
                        </div>
                        <!-- FAQ Item 2 -->
                        <div class="accordion-item mb-3 border-0 shadow-sm">
                            <h2 class="accordion-header" id="headingTwo">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseTwo">
                                    How long do I have access to the course materials?
                                </button>
                            </h2>
                            <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                                data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    All our courses come with lifetime access. Once you enroll, you can access the
                                    course materials anytime, anywhere, forever. This includes all future updates to the
                                    course content at no additional cost.
                                </div>
                            </div>
                        </div>
                        <!-- FAQ Item 3 -->
                        <div class="accordion-item mb-3 border-0 shadow-sm">
                            <h2 class="accordion-header" id="headingThree">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseThree">
                                    What if I'm not satisfied with the course?
                                </button>
                            </h2>
                            <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                                data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    Course is very helpful for your trading. There is no any refundable policy. Course fee is completely non-refundable.
                                </div>
                            </div>
                        </div>
                        <!-- FAQ Item 4 -->
                        <div class="accordion-item mb-3 border-0 shadow-sm">
                            <h2 class="accordion-header" id="headingFour">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseFour">
                                    Do I need any special software or tools to take these courses?
                                </button>
                            </h2>
                            <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                                data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    No special software is required. All you need is a computer or smartphone with
                                    internet access to watch the video lessons. For practical trading, we'll guide you
                                    on free tools and platforms you can use to apply what you learn.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Register Section -->
    <!-- <section id="register" class="py-5 bg-primary text-white">
        <div class="container text-center">
            <h2 class="display-5 fw-bold mb-4">Ready to Start Your Trading Journey?</h2>
            <p class="fs-5 mb-5 mx-auto" style="max-width: 700px;">Join thousands of students who have transformed their
                financial future with our proven trading education system. Get started with our free introductory course
                today.</p>
            <a href="#" class="btn btn-light btn-lg px-5">Register Now for Free <i
                    class="fas fa-arrow-right ms-2"></i></a>
        </div>
    </section> -->
    <!-- Footer -->
    <?php include "./footer.php" ?>
    <!-- Bootstrap 5 JS (Offline) -->
    <script src="bootstrap/js/bootstrap.bundle.min.js"></script>
    <script>
        // Back to top button
        window.addEventListener('scroll', function () {
            var backToTop = document.querySelector('.back-to-top');
            if (window.pageYOffset > 300) {
                backToTop.classList.add('active');
            } else {
                backToTop.classList.remove('active');
            }
        });
        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                document.querySelector(this.getAttribute('href')).scrollIntoView({
                    behavior: 'smooth'
                });
            });
        });
    </script>
</body>
</html>