<!-- <!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Our Service</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet" /> -->
  <style>
    /* body {
      font-family: 'Poppins', sans-serif;
      background-color: #f8f9fa;
    } */

    .service-chart .box {
      background: linear-gradient(135deg, #e67e22, #d35400);
      color: #fff;
      padding: 20px;
      border-radius: 12px;
      font-weight: 600;
      text-align: center;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .service-chart .box:hover {
      transform: translateY(-5px);
      box-shadow: 0 6px 20px rgba(0, 0, 0, 0.3);
    }

    .line {
      width: 4px;
      height: 40px;
      background: #e67e22;
      margin: 0 auto;
      border-radius: 2px;
    }

    .connector-horizontal {
      height: 4px;
      background: #e67e22;
      position: relative;
      top: -20px;
      border-radius: 2px;
    }

    .connector-horizontal::before,
    .connector-horizontal::after {
      content: '';
      position: absolute;
      width: 4px;
      height: 20px;
      background: #e67e22;
      top: 0;
    }

    .connector-horizontal::before {
      left: 25%;
    }

    .connector-horizontal::after {
      right: 25%;
    }

    .service-image {
      transition: transform 0.3s ease;
    }

    .service-image:hover {
      transform: scale(1.05);
    }

    @media (max-width: 768px) {
      .connector-horizontal {
        display: none;
      }

      .line {
        height: 20px;
      }

      .service-chart .box {
        font-size: 0.9rem;
        padding: 15px;
      }
    }

    .section-title {
      font-size: 2.5rem;
      font-weight: 600;
      color: #2c3e50;
      text-align: center;
      margin-bottom: 3rem;
      position: relative;
    }

    .section-title::after {
      content: '';
      width: 80px;
      height: 4px;
      background: #e67e22;
      position: absolute;
      bottom: -10px;
      left: 50%;
      transform: translateX(-50%);
      border-radius: 2px;
    }
  </style>
</head>
<body>
  <section class="py-5">
    <div class="container">
      <h2 class="section-title animate__animated animate__fadeIn">Our Services</h2>
      <div class="row align-items-center">
        <!-- Image -->
        <div class="col-md-5 mb-4 mb-md-0 text-center">
          <img src="assets/ourservice.webp" alt="Service Image" class="img-fluid rounded shadow service-image" />
        </div>

        <!-- Flowchart -->
        <div class="col-md-7 service-chart">
          <!-- Center Box -->
          <div class="box mb-4 mx-auto animate__animated animate__zoomIn" style="max-width: 300px;">
            Our Service
          </div>

          <!-- Line -->
          <div class="line mb-4"></div>

          <!-- Horizontal connector -->
          <div class="connector-horizontal mb-4 d-flex justify-content-between">
            <div style="width: 25%"></div>
            <div style="width: 25%"></div>
            <div style="width: 25%"></div>
            <div style="width: 25%"></div>
          </div>

          <!-- Sub-services -->
          <div class="row text-center">
            <div class="col-md-3 mb-3">
              <div class="box animate__animated animate__fadeInUp" data-animate-delay="0.1s">
                Online<br />Education
              </div>
            </div>
            <div class="col-md-3 mb-3">
              <div class="box animate__animated animate__fadeInUp" data-animate-delay="0.2s">
                Software<br />Selling
              </div>
            </div>
            <div class="col-md-3 mb-3">
              <div class="box animate__animated animate__fadeInUp" data-animate-delay="0.3s">
                Business<br />Development
              </div>
            </div>
            <div class="col-md-3 mb-3">
              <div class="box animate__animated animate__fadeInUp" data-animate-delay="0.4s">
                Marketing<br />Plan
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"></script> -->
  <script>
    // Add animation delay dynamically
    document.querySelectorAll('.animate__animated').forEach((el) => {
      const delay = el.getAttribute('data-animate-delay');
      if (delay) {
        el.style.animationDelay = delay;
      }
    });
  </script>
<!-- </body>
</html> -->