
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
      
        
        .values-section {
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            padding: 100px 0;
            position: relative;
        }
        
        .values-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('https://images.unsplash.com/photo-1611974789855-9c2a0a7236a3?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80') center/cover;
            opacity: 0.03;
        }
        
        .section-header {
            text-align: center;
            margin-bottom: 60px;
            position: relative;
        }
        
        .section-header h2 {
            font-size: 2.8rem;
            font-weight: 800;
            color: var(--dark-color);
            margin-bottom: 20px;
        }
        
        .section-header .divider {
            width: 80px;
            height: 4px;
            background: var(--primary-color);
            margin: 0 auto;
            border-radius: 2px;
        }
        
        .value-card {
            background: white;
            border-radius: 16px;
            padding: 40px 30px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            height: 100%;
            position: relative;
            overflow: hidden;
            border: none;
        }
        
        .value-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.1);
        }
        
        .value-card.mission {
            border-top: 4px solid var(--primary-color);
        }
        
        .value-card.vision {
            border-top: 4px solid #10b981;
        }
        
        .value-icon {
            font-size: 2.5rem;
            color: var(--primary-color);
            margin-bottom: 20px;
        }
        
        .value-card.vision .value-icon {
            color: #10b981;
        }
        
        .value-title {
            font-size: 1.8rem;
            font-weight: 700;
            margin-bottom: 20px;
            color: var(--dark-color);
        }
        
        .value-content {
            font-size: 1.1rem;
            line-height: 1.8;
            color: #4b5563;
        }
        
        .highlight-box {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            border-radius: 16px;
            padding: 60px;
            color: white;
            margin-top: 60px;
            position: relative;
            overflow: hidden;
        }
        
        .highlight-box::before {
            content: '';
            position: absolute;
            top: -50px;
            right: -50px;
            width: 200px;
            height: 200px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .highlight-box::after {
            content: '';
            position: absolute;
            bottom: -80px;
            left: -80px;
            width: 250px;
            height: 250px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .highlight-title {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 20px;
        }
        
        .highlight-content {
            font-size: 1.2rem;
            line-height: 1.8;
            opacity: 0.9;
            margin-bottom: 30px;
        }
        
        .stats-number {
            font-size: 3rem;
            font-weight: 800;
            margin-bottom: 5px;
        }
        
        .stats-label {
            font-size: 1.1rem;
            opacity: 0.9;
        }
        
        @media (max-width: 768px) {
            .section-header h2 {
                font-size: 2rem;
            }
            
            .value-card {
                padding: 30px 20px;
                margin-bottom: 30px;
            }
            
            .highlight-box {
                padding: 40px 30px;
            }
        }
    </style>


<!-- Our Values Section -->
<section class="values-section">
    <div class="container position-relative">
        <div class="section-header">
            <h2>Our Value</h2>
            <div class="divider"></div>
        </div>
        
        <div class="row g-4">
            <!-- Mission Card -->
            <div class="col-lg-6">
                <div class="value-card mission">
                    <div class="value-icon">
                        <i class="fas fa-bullseye"></i>
                    </div>
                    <h3 class="value-title">Our Mission</h3>
                    <div class="value-content">
                        <p>Revolutionize stock market education and empower individuals by providing Smart Education. Through innovative tools like automatic trading guide software and a robust networking model, we aim to foster financial literacy, entrepreneurship, and success.</p>
                    </div>
                </div>
            </div>
            
            <!-- Vision Card -->
            <div class="col-lg-6">
                <div class="value-card vision">
                    <div class="value-icon">
                        <i class="fas fa-eye"></i>
                    </div>
                    <h3 class="value-title">Our Vision</h3>
                    <div class="value-content">
                        <p>Redefine stock market education and create a lasting impact by empowering 1 lakh+ traders and investors with knowledge, tools, and confidence to achieve financial freedom with a unique networking business model.</p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Highlight Box -->
        <!-- <div class="highlight-box">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <h3 class="highlight-title">Transforming Trading Education</h3>
                    <p class="highlight-content">We're committed to breaking down barriers to financial education by combining cutting-edge technology with proven trading strategies and a revolutionary networking approach.</p>
                </div>
                <div class="col-lg-4">
                    <div class="text-center">
                        <div class="stats-number" data-target="100">0</div>
                        <div class="stats-label">Thousand+ Traders to Empower</div>
                    </div>
                </div>
            </div>
        </div> -->
    </div>
</section>

<!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script> -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Animate the stats number
        function animateValue(obj, start, end, duration) {
            let startTimestamp = null;
            const step = (timestamp) => {
                if (!startTimestamp) startTimestamp = timestamp;
                const progress = Math.min((timestamp - startTimestamp) / duration, 1);
                obj.innerHTML = Math.floor(progress * (end - start) + start) + (progress === 1 ? "+" : "");
                if (progress < 1) {
                    window.requestAnimationFrame(step);
                }
            };
            window.requestAnimationFrame(step);
        }
        
        // Animate when the element comes into view
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    const numberElement = entry.target.querySelector('.stats-number');
                    if (numberElement) {
                        const target = parseInt(numberElement.getAttribute('data-target'));
                        animateValue(numberElement, 0, target, 2000);
                    }
                    observer.unobserve(entry.target);
                }
            });
        }, { threshold: 0.1 });
        
        observer.observe(document.querySelector('.highlight-box'));
    });
</script>
<!-- </body>
</html> -->