<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Stock Market Courses - Beginner to Expert</title>
  <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    
    .hero-section {
      background: linear-gradient(135deg, #1e3a8a 0%, #2563eb 100%);
      color: white;
      padding: 100px 0;
      position: relative;
      overflow: hidden;
    }
    
    .hero-section::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: url('https://www.transparenttextures.com/patterns/diagonal-striped-brick.png');
      opacity: 0.05;
    }
    
    .course-card {
      background: white;
      border-radius: 16px;
      overflow: hidden;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
      transition: all 0.3s ease;
      margin-bottom: 30px;
      border: none;
    }
    
    .course-card:hover {
      transform: translateY(-10px);
      box-shadow: 0 15px 40px rgba(0, 0, 0, 0.15);
    }
    
    .course-header {
      background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
      color: white;
      padding: 20px;
      text-align: center;
    }
    
    .course-body {
      padding: 30px;
    }
    
    .topic-list {
      list-style-type: none;
      padding-left: 0;
    }
    
    .topic-list li {
      padding: 8px 0;
      padding-left: 30px;
      position: relative;
      border-bottom: 1px solid #f1f1f1;
    }
    
    .topic-list li:before {
      content: '\f00c';
      font-family: 'Font Awesome 6 Free';
      font-weight: 900;
      position: absolute;
      left: 0;
      color: var(--primary-color);
    }
    
    .free-banner {
      background: linear-gradient(135deg, #f59e0b 0%, #f97316 100%);
      color: white;
      padding: 15px 30px;
      border-radius: 8px;
      text-align: center;
      margin: 30px 0;
      position: relative;
      overflow: hidden;
      box-shadow: 0 10px 20px rgba(245, 158, 11, 0.3);
    }
    
    .free-banner::before {
      content: '';
      position: absolute;
      top: -20px;
      right: -20px;
      width: 100px;
      height: 100px;
      background: rgba(255, 255, 255, 0.2);
      border-radius: 50%;
    }
    
    .free-banner h3 {
      font-weight: 700;
      margin-bottom: 10px;
    }
    
    .free-banner .badge {
      background: rgba(0, 0, 0, 0.2);
      font-size: 1rem;
      font-weight: 600;
      padding: 5px 15px;
      border-radius: 50px;
    }
    
    .section-title {
      position: relative;
      margin-bottom: 50px;
      text-align: center;
    }
    
    .section-title:after {
      content: '';
      position: absolute;
      bottom: -15px;
      left: 50%;
      transform: translateX(-50%);
      width: 80px;
      height: 4px;
      background: var(--primary-color);
      border-radius: 2px;
    }
    
    .nav-pills .nav-link.active {
      background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
    }
    
    .nav-pills .nav-link {
      color: var(--dark-color);
      font-weight: 500;
    }
    
    @media (max-width: 768px) {
      .hero-section {
        padding: 60px 0;
      }
      
      .course-body {
        padding: 20px;
      }
    }
  </style>
      <link rel="stylesheet" href="assets/style.css">
</head>
<body>
   <!-- Navigation Bar -->
    <?php
    include "./header.php"
        ?>
<!-- Hero Section -->
<!-- <section class="hero-section">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-8 mx-auto text-center">
        <h1 class="display-4 fw-bold mb-4">Master the Stock Market</h1>
        <p class="lead mb-5">From beginner to expert - Learn trading strategies that work with our comprehensive courses</p>
        <a href="#courses" class="btn btn-light btn-lg px-5 py-3 fw-bold">Explore Courses</a>
      </div>
    </div>
  </div>
</section> -->
<!-- Top Badge -->
<style>
   
    .deal-section {
      background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
      padding: 80px 0;
      position: relative;
      overflow: hidden;
    }
    
    .deal-section::before {
      content: '';
      position: absolute;
      top: -50px;
      right: -50px;
      width: 200px;
      height: 200px;
      background: rgba(214, 51, 132, 0.1);
      border-radius: 50%;
      z-index: 0;
    }
    
    .deal-section::after {
      content: '';
      position: absolute;
      bottom: -80px;
      left: -80px;
      width: 250px;
      height: 250px;
      background: rgba(32, 201, 151, 0.1);
      border-radius: 50%;
      z-index: 0;
    }
    
    .deal-badge {
      font-size: 2.8rem;
      font-weight: 800;
      color: white;
      background: linear-gradient(135deg, var(--primary-color) 0%, #a61e4d 100%);
      display: inline-block;
      padding: 20px 40px;
      border-radius: 12px;
      box-shadow: 0 10px 30px rgba(214, 51, 132, 0.3);
      transform: rotate(-3deg);
      position: relative;
      z-index: 1;
      border: 3px dashed rgba(255,255,255,0.3);
      text-transform: uppercase;
      letter-spacing: 1px;
    }
    
    .offer-strip {
      background: linear-gradient(135deg, var(--accent-color) 0%, #ffda6a 100%);
      font-weight: 700;
      color: var(--dark-color);
      padding: 12px 20px;
      border-radius: 50px;
      margin: 30px auto 0;
      display: inline-block;
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
      position: relative;
      z-index: 1;
      font-size: 1.2rem;
    }
    
    .price-box {
      background: linear-gradient(135deg, var(--dark-color) 0%, #343a40 100%);
      color: white;
      padding: 50px 30px;
      border-radius: 16px;
      margin-top: 40px;
      position: relative;
      z-index: 1;
      box-shadow: 0 15px 40px rgba(0,0,0,0.15);
      border: 2px solid rgba(255,255,255,0.1);
      overflow: hidden;
    }
    
    .price-box::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: url('https://www.transparenttextures.com/patterns/diagonal-striped-brick.png');
      opacity: 0.05;
      z-index: -1;
    }
    
    .old-price {
      font-size: 2.2rem;
      text-decoration: line-through;
      opacity: 0.7;
      position: relative;
      display: inline-block;
    }
    
    .old-price::after {
      content: '75% OFF';
      position: absolute;
      top: -15px;
      right: -60px;
      background: var(--primary-color);
      color: white;
      font-size: 0.9rem;
      padding: 3px 10px;
      border-radius: 50px;
      font-weight: 700;
    }
    
    .now-price {
      font-size: 3.5rem;
      font-weight: 800;
      margin: 10px 0;
      color: var(--accent-color);
      text-shadow: 0 2px 5px rgba(0,0,0,0.2);
    }
    
    .offer-tag {
      font-size: 1.2rem;
      font-weight: 600;
      letter-spacing: 1px;
      margin-top: 15px;
    }
    
    .bonus-box {
      background: linear-gradient(135deg, #495057 0%, var(--dark-color) 100%);
      color: white;
      padding: 30px;
      border-radius: 16px;
      margin: 40px auto 0;
      max-width: 600px;
      position: relative;
      z-index: 1;
      box-shadow: 0 10px 30px rgba(0,0,0,0.15);
      border: 2px solid rgba(255,255,255,0.1);
      overflow: hidden;
    }
    
    .bonus-box::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: url('https://www.transparenttextures.com/patterns/diagonal-striped-brick.png');
      opacity: 0.05;
      z-index: -1;
    }
    
    .bonus-box strong {
      color: var(--accent-color);
      font-weight: 700;
    }
    
    .bonus-icon {
      font-size: 1.5rem;
      margin-right: 10px;
      color: var(--accent-color);
    }
    
    .timer-box {
      background: rgba(255,255,255,0.9);
      padding: 20px;
      border-radius: 12px;
      margin: 30px auto 0;
      max-width: 500px;
      box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    }
    
    .timer-label {
      font-size: 1.1rem;
      font-weight: 600;
      color: var(--dark-color);
      margin-bottom: 10px;
    }
    
    .timer {
      font-size: 1.8rem;
      font-weight: 700;
      color: var(--primary-color);
      font-family: monospace;
    }
    
    .guarantee-badge {
      background: rgba(32, 201, 151, 0.15);
      color: var(--secondary-color);
      padding: 8px 20px;
      border-radius: 50px;
      font-weight: 600;
      display: inline-block;
      margin-top: 30px;
      border: 1px dashed var(--secondary-color);
    }
    
    @media (max-width: 768px) {
      .deal-badge {
        font-size: 2rem;
        padding: 15px 25px;
      }
      
      .old-price {
        font-size: 1.8rem;
      }
      
      .now-price {
        font-size: 2.8rem;
      }
    }
  </style>
 <section class="deal-section">
    <div class="container position-relative">
      <div class="row justify-content-center">
        <div class="col-lg-10 text-center">
          <div class="deal-badge animate__animated animate__pulse animate__infinite">
            <i class="fas fa-bolt me-2"></i>Flash Sale Ending Soon!
          </div>
          
          <!-- Offer Strip -->
          <div class="offer-strip animate__animated animate__fadeIn">
            <i class="fas fa-tag me-2"></i>Buy any Course of ₹ <strike>10,000</strike>/- for Just ₹2,500/-
          </div>
        </div>
      </div>
    </div>
  </section>
		  
<!-- Courses Section -->
<section id="courses" class="py-5">
  <div class="container">
    <h2 class="section-title">Our Comprehensive Courses</h2>
    
    <ul class="nav nav-pills mb-5 justify-content-center" id="course-tabs" role="tablist">
      <li class="nav-item" role="presentation">
        <button class="nav-link active" id="beginner-tab" data-bs-toggle="pill" data-bs-target="#beginner" type="button" role="tab">Beginner Course</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="advanced-tab" data-bs-toggle="pill" data-bs-target="#advanced" type="button" role="tab">Advanced Course</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="expert-tab" data-bs-toggle="pill" data-bs-target="#expert" type="button" role="tab">Options Expert</button>
      </li>
    </ul>
    
    <div class="tab-content" id="course-tabs-content">
      <!-- Beginner Course -->
      <div class="tab-pane fade show active" id="beginner" role="tabpanel">
        <div class="row">
          <div class="col-lg-8 mx-auto">
            <div class="course-card">
              <div class="course-header">
                <h3>Beginner Stock Market Course</h3>
                <p class="mb-0">Foundation for New Investors & Traders</p>
              </div>
              <div class="course-body">
                <h4 class="mb-4">Topics Covered:</h4>
                <ul class="topic-list">
                  <li>What is stock market?</li>
                  <li>Role of NSE and BSE</li>
                  <li>Why companies listed in stock market</li>
                  <li>Why should we invest in companies</li>
                  <li>How much money we required?</li>
                  <li>Primary market IPO?</li>
                  <li>What is secondary market?</li>
                  <li>About market cap, small cap, large cap, mid cap</li>
                  <li>What is indices</li>
                  <li>Equity market or derivative market</li>
                  <li>All about Demat account</li>
                  <li>Types of trading?</li>
                  <li>How to use trading terminal, entry, exit, stop loss</li>
                  <li>What are charts?</li>
                  <li>How to use charting platforms trading view</li>
                  <li>How to start investing</li>
                  <li>What are exchange trading funds (ETF)</li>
                  <li>What are mutual funds and sip</li>
                  <li>Pro and cons of sip</li>
                  <li>Systematic investment using our premium indicator</li>
                </ul>
                
                <!-- Free Banner -->
                <div class="free-banner">
                  <span class="badge mb-2">FREE BONUS</span>
                  <h3>Get Free Smart ETF Signal Indicator</h3>
                  <p class="mb-0">Worth ₹15,000 For one year with this course</p>
                </div>
                
                <div class="d-grid gap-2">
                  <button class="btn btn-primary btn-lg">Enroll Now</button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Advanced Course -->
      <div class="tab-pane fade" id="advanced" role="tabpanel">
        <div class="row">
          <div class="col-lg-8 mx-auto">
            <div class="course-card">
              <div class="course-header">
                <h3>Advanced Trading Course</h3>
                <p class="mb-0">Master Technical Analysis & Strategies</p>
              </div>
              <div class="course-body">
                <h4 class="mb-4">Topics Covered:</h4>
                <ul class="topic-list">
                  <li>Types of Trading?</li>
                  <li>Types of candlestick</li>
                  <li>Bullish Patterns + Trading Strategy</li>
                  <li>Bearish Patterns + Trading Strategy</li>
                  <li>Intraday Trading</li>
                  <li>Stock selection method 1 for intraday trading</li>
                  <li>ORB Breakout Strategy and candle time frame</li>
                  <li>Volume Analysis</li>
                  <li>What are Indicators</li>
                  <li>About lagging indicators and trading strategy</li>
                  <li>About Leading Indicators and trading strategy</li>
                  <li>Sector wise Stock selection for intraday trading</li>
                  <li>Vwap trading strategy</li>
                  <li>Stock selection method 3 for intraday trading</li>
                  <li>Short term swing trading</li>
                  <li>Range breakout Strategy</li>
                  <li>Support/ Resistance trading</li>
                  <li>Stock selection for swing trading</li>
                  <li>Trading Psychology: Managing emotions and discipline</li>
                  <li>Long-term investment using sector analysis</li>
                </ul>
                
                <!-- Free Banner -->
                <div class="free-banner">
                  <span class="badge mb-2">FREE BONUS</span>
                  <h3>Get Free Smart Intraday Signal Indicator</h3>
                  <p class="mb-0">Worth ₹15,000 For one year with this course</p>
                </div>
                
                <div class="d-grid gap-2">
                  <button class="btn btn-primary btn-lg">Enroll Now</button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Options Expert Course -->
      <div class="tab-pane fade" id="expert" role="tabpanel">
        <div class="row">
          <div class="col-lg-8 mx-auto">
            <div class="course-card">
              <div class="course-header">
                <h3>Options Expert Course</h3>
                <p class="mb-0">Master Options Trading Strategies</p>
              </div>
              <div class="course-body">
                <h4 class="mb-4">Topics Covered:</h4>
                <ul class="topic-list">
                  <li>Introduction of Options?</li>
                  <li>Understanding Option Terminology: strike price, premium, expiration etc</li>
                  <li>Option Moneyness: In-the-money, at-the-money, out-of-the-money</li>
                  <li>Option Chain Analysis</li>
                  <li>Index option trading</li>
                  <li>What is open interest</li>
                  <li>Identify market range using open interest</li>
                  <li>What are Option Greeks</li>
                  <li>Introduction to Volatility: Implied volatility</li>
                  <li>What is PCR and how to use for trading</li>
                  <li>VIX and its impact on options</li>
                  <li>Option Buying vs. Option selling</li>
                  <li>Option Trading Using Vwap Indicator</li>
                  <li>OI Stats chart and trading strategy</li>
                  <li>What are Option strategies</li>
                  <li>Non directional strategies</li>
                  <li>Up trend market option hedging strategies</li>
                  <li>Down trend market option hedging strategies</li>
                  <li>Calendar trading strategies</li>
                  <li>Options Trading Psychology: Managing Emotion and discipline</li>
                </ul>
                
                <!-- Free Banner -->
                <div class="free-banner">
                  <span class="badge mb-2">FREE BONUS</span>
                  <h3>Get Free Smart Intraday Signal Indicator</h3>
                  <p class="mb-0">Worth ₹15,000 For one year with this course</p>
                </div>
                
                <div class="d-grid gap-2">
                  <button class="btn btn-primary btn-lg">Enroll Now</button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
   <!-- Footer -->
   <?php include "./footer.php" ?>
<script src="bootstrap/js/bootstrap.bundle.min.js"></script>
</body>
</html>